%----------------------------------------------------------------
% ACTRLOAD.M loads the parameters (state-space matrices) for the
% cable and actuator models of the `Beaver' aircraft. These para-
% meters are needed for the autopilot simulation models, APILOT1,
% APILOT2, APILOT3, PAH, RAH, and PAHRAH.
%----------------------------------------------------------------

% Note: the variable refvelocity contains the reference velocity for which the
% actuator model is loaded. It is defined by this Matlab macro for later use, 
% e.g. for the routine KPAHRAH.

clc
actuator_model = txtmenu('Specify desired actuator & cable model', ...
                         'Model for V=35 m/s', ...
                         'Model for V=45 m/s', ...
                         'Model for V=55 m/s', ...
                         'Ready');

if ~isempty(actuator_model)
   clc
   disp(' ');
   if actuator_model == 1
     load actmod35.dat -mat
     refvelocity = 35;
     disp('Actuator and cable model for V=35 m/s loaded.');
   elseif actuator_model == 2
     load actmod45.dat -mat
     refvelocity = 45;
     disp('Actuator and cable model for V=45 m/s loaded.');
   elseif actuator_model == 3
     load actmod55.dat -mat
     refvelocity = 55;
     disp('Actuator and cable model for V=55 m/s loaded.');
   else
     disp('Warning: No new actuator and cable model loaded.');
   end
   disp(' ');
end

clear actuator_model h

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------